<!DOCTYPE html>
<html>
% include('header.tpl', title='Ethics and consent')

<body>
    <div class="container">

      <h1>Ethical approval and consent</h1>
      <p>Please read the following text carefully and click the <span class="letter_spaced">CONTINUE</span> button at the end.</p>
      <h2>Information Sheet</h2>
      <p>This study investigates the perception of different type-designs.</p>
      <p>Participation is completely voluntary. Participation involves judging a stimulus in the form of lettershapes. It will take about {{ study_duration }} minutes to complete. You will be rewarded £ {{ round(6.8 / 60 * study_duration, 2) }} though Prolific Academic  upon completion. There is no risk for the participant. </p>
      <p>You must be at least 18 years old to participate. </p>
      <p>You may withdraw from the study at any time by closing your web browser. </p>
      <p>All data provided are confidential. Your participation is anonymous. The results of the study may be published in one or more academic publications and as part of research databases.</p>
      <p>This project has been subject to ethical review, according to the procedures specified by the University Research Ethics Committee, and has been given a favourable ethical approval (UTREC number: CS11994).</p>
      <p>If you have concerns about this study you can find a full outline of the procedures governed by the University Teaching and Research Ethics Committee of the University of St Andrews, which is available <a href ='http://www.st-andrews.ac.uk/utrec/guidelinespolicies/complaints/' target = '_blank'>here</a>.</p>
      <p>Please contact Miguel Nacenta (University of St Andrews, e-mail: <span style="white-space: nowrap;">
      <a href ='mailto:mans@st-andrews.ac.uk?Subject=Question about the study'>
      mans@st-andrews.ac.uk</a></span>) to address any questions or learn more about the study.</p>

      <h2>Consent</h2>
      <form id='consent' action="./user">
          <p>The University of St Andrews attaches high priority to the ethical conduct of research.  We therefore ask you to consider the following points before deciding to participate in this research. Answering the questions below and pressing the <span class = "letter_spaced">CONTINUE</span> button represents explicit agreement to participate in this experiment and to allow us to analyse and use your data.</p>

          <fieldset class="consent_checkboxes">
          <p><label><input type="checkbox" required> I have read and understood the information above. </label></p>
          <p><label><input type="checkbox" required> I have had my questions answered satisfactorily.  </label></p>
          <p><label><input type="checkbox" id="cbox02" value="checkbox_02" required> I understand that my data will be anonymous.</label><p>
          <p><label><input type="checkbox" required> I understand that my data will be kept indefinitely and published as part of scientific publications and scientific databases.</label></p>
          <p><label><input type="checkbox" required> I understand that I can withdraw from the study without having to give an explanation.</label></p>
          <p><label><input type="checkbox" required> I agree to my data being kept, archived, and used by further research projects.</label></p>
          <p><label><input type="checkbox" required> I agree to take part in this study.</label></p>
          </fieldset>
        <input type="submit" value="C O N T I N U E">
      </form>

    </div>

% include('footer.tpl', anything='A study')

</body>
</html>
